<?php defined('SYSPATH') or die('No direct script access.');

class Task_Parser_Citrix extends Minion_Task{
    protected function _execute(array $params){
        $my_words = [
//            '+CSCOE+',
//            '+webvpn+',
//            'XenApp',
            'citrix'
        ];

        foreach($my_words as $key_word){
            $query = $this->getQuery($key_word);
            $fp = fopen('/home/parser/'.$key_word.'.csv', 'w');
            foreach($query as $item){
                $tmp_array = array();
                foreach($item as $key => $item2){
                    if($key != 'data'){
                        $tmp_array[] = $item2;
                    }else{
                        $data_string = '';
                        $data = json_decode($item2, true);
                        foreach($data as $k => $d){
                            $data_string .= $k.": ".$d."\n\r";
                        }
                        $tmp_array[] = $data_string;
                    }
                }
                fputcsv($fp, $tmp_array);
            }

            fclose($fp);
        }
    }

    private function getQuery($key_word){
        return DB::select('t.client', 'l.host', 'l.post', 'l.referrer', 'l.link', 'l.datetime', 'l.data')
            ->from(['logpost', 'l'])
            ->join(['test', 't'])
            ->on('l.test_id', '=', 't.id')
            ->where(DB::expr('(EXTRACT(MONTH FROM l.datetime))'), 'BETWEEN', [5, 6])
////            ->where_open()
////                ->where(DB::expr('(EXTRACT(MONTH FROM l.datetime))'), '=', 1)
////                ->or_where(DB::expr('(EXTRACT(MONTH FROM l.datetime))'), '=', 2)
////            ->where_close()
            ->and_where_open()
                ->where('l.link', 'LIKE', '%'.$key_word.'%')
                ->or_where('l.referrer', 'LIKE', '%'.$key_word.'%')
                ->or_where('l.data', 'LIKE', '%'.$key_word.'%')
            ->and_where_close()
            ->execute()
            ->as_array();
    }
}